const Sequelize = require('sequelize');
module.exports = function (sequelize, DataTypes) {
  return sequelize.define('tbl_rpi', {
    RecNo: {
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true,
      autoIncrement: true
    },
    RPIID: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
    },
    IDSNo: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    DS_IP: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL"
    },
    DS_NUMBER: {
      type: DataTypes.STRING(100),
      allowNull: true,
      defaultValue: "NULL",
      unique: true,
    },
  }, {
    sequelize,
    tableName: 'tbl_rpi',
    timestamps: false,
    indexes: [
      {
        name: "PRIMARY",
        unique: true,
        using: "BTREE",
        fields: [
          { name: "RecNo" },
        ]
      },
      {
        name: "index_DS_NUMBER",
        unique: true,
        fields: [
          { name: "DS_NUMBER" }
        ]
      }
    ]
  });
};
